class Ex7_1
/*pressure conversion from atm to N/m^2, 1 atm=1.01*10^5 N/m^2;*/

parameter Real S(unit="m^2")=5*7;/*area of the floor of the room*/
parameter Real height(unit="m")=3.3;/*height of the room*/
Real v(unit="m^3");/*volume of the room*/

parameter Real p_atm(unit="atm")=1;/*air pressure in the room in atm unit*/
Real p(unit="N/m^2");/*air pressure in room in N/m^2 unit*/

parameter Real T_degc(unit="degC")=25;/*air temperature in the room in degree celcius unit*/ 
Real T(unit="K");/*air temperature in the room in kelvin unit*/

Real rho(unit="kg/m^3");/*density of air in the room*/
Real M(unit="kg");/*Mass of air in the room*/

parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg*K")=287;/*Specific Gas Constant of Air*/

Real c_v(unit="joule/kg.K");/*specific heat at constant volume*/
Real e(unit="joule/kg");/*specific internal energy*/
Real E(unit="joule");/*internal energy*/

Real c_p(unit="joule/kg.K");/*specific heat at constant pressure*/
Real h(unit="joule/kg");/*specific enthalpy*/
Real H(unit="joule");/*enthalpy in the room*/

equation
v=S*height;
p=p_atm*1.01*10^5;
T=Modelica.SIunits.Conversions.from_degC(T_degc);
rho=p/(R*T);
M=rho*v;
c_v=R/(gama-1);
e=c_v*T;
E=M*e;
c_p=(gama*R)/(gama-1);
h=c_p*T;
H=M*h;

end Ex7_1;
