class Ex7_3
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg*K")=287;/*Specific Gas Constant of Air*/

Real c_p(unit="joule/kg.K");/*specific heat at constant pressure*/

parameter Real V(unit="m/s")=1000;/*velocity of the airflow*/

parameter Real T(unit="K")=320;/*temperature at a point in the airfoil*/
Real T_0(unit="K");/*total temperature at a point in the airfoil*/

parameter Real p(unit="atm")=1;/*pressure at a point in the airfoil*/
Real p_0(unit="atm");/*total pressure at a point in the airfoil*/

equation
c_p=(gama*R)/(gama-1);

c_p*T+V^2/2=c_p*T_0;

p_0/p=(T_0/T)^(gama/(gama-1));

/*The  answer may slightly vary due to  rounding off values*/
end Ex7_3;
