class Ex8_5
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg*K")=287;/*Specific Gas Constant of Air*/

parameter Real M=3.5;/*local Mach number*/
Real V(unit="m/s");/*velocity of the airflow*/
Real a(unit="m/s");/*spaeed of sound at T=320 K*/

parameter Real T(unit="K")=180;/*temperature at a point in the airfoil*/
parameter Real T_0_by_T=3.45;/*ratio of total temperature and static temperature*/
parameter Real T_0_by_T_star=1.2;/*ratio of total temperature and temperature at sonic condition*/


parameter Real p(unit="atm")=0.3;/*pressure at a point in the airfoil*/
parameter Real p_0_by_p=76.27;/*ratio of total pressure and static pressure*/

Real T_0(unit="K");/*total temperature at a point in the airfoil*/
Real p_0(unit="atm");/*total pressure at a point in the airfoil*/

Real T_star(unit="K");/*static temperature at sonic condition*/
Real a_star(unit="m/s");/*speed of sound at sonic condition*/
Real M_star;/*characteristic Mach number*/

equation
p_0=p_0_by_p*p;
T_0=T_0_by_T*T;

T_star=T_0/T_0_by_T_star;

a_star=sqrt(gama*R*T_star);
a=sqrt(gama*R*T);
V=M*a;
M_star=V/a_star;

/*The  answer may slightly vary due to  rounding off values*/
end Ex8_5;
