class Ex8_7
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg*K")=287;/*Specific Gas Constant of Air*/

parameter Real p_infinite(unit="atm")=1;/*free stream pressure*/
parameter Real p_1(unit="atm")=0.7545;/*pressure at a point in the airfoil*/

parameter Real T_infinite_F(unit="degF")=59;/*free stream temperature in degree fahrenheit*/
Real T_infinite(unit="K");/*free stream temperature in kelvin*/
Real T_1(unit="K");/*temperature at a point in the airfoil*/

parameter Real M_1=0.9;/*local Mach number*/
Real a_1(unit="m/s");/*spaeed of sound */
Real V_1(unit="m/s");/*velocity of the airflow*/

equation
T_infinite=Modelica.SIunits.Conversions.from_degF(T_infinite_F);

p_1/p_infinite=(T_1/T_infinite)^(gama/(gama-1));

a_1=sqrt(gama*R*T_1);
V_1=M_1*a_1;

/*The  answer may slightly vary due to  rounding off values*/
end Ex8_7;
