package Ex8_9
model Ex8_9_a
parameter Real M1=2;/*upstream Mach number*/
parameter Real p1(unit="atm")=1;/*upstream pressure*/
parameter Real p01_by_p1=7.824;/*ratio of upstream total pressure and static pressure*/
Real p01(unit="atm");/*upstream total pressure*/

parameter Real p02_by_p01=0.7209;/*ratio of downstream total pressure and upstream total pressure*/
Real p02(unit="atm");/*downstream total pressure*/
Real p01_p02(unit="atm");/*loss of total pressure*/

equation
p01=p01_by_p1*p1;
p02=p02_by_p01*p01;
p01_p02=p01-p02;
end Ex8_9_a;

model Ex8_9_b
parameter Real M1=4;/*upstream Mach number*/
parameter Real p1(unit="atm")=1;/*upstream pressure*/
parameter Real p01_by_p1=151.8;/*ratio of upstream total pressure and static pressure*/
Real p01(unit="atm");/*upstream total pressure*/

parameter Real p02_by_p01=0.1388;/*ratio of downstream total pressure and upstream total pressure*/
Real p02(unit="atm");/*downstream total pressure*/
Real p01_p02(unit="atm");/*loss of total pressure*/

equation
p01=p01_by_p1*p1;
p02=p02_by_p01*p01;
p01_p02=p01-p02;
end Ex8_9_b;
end Ex8_9;
