class Ex9_10
parameter Real p1(unit="atm")=1;/*pressure ahead of oblique shock*/ 
parameter Real M_1=10;/*Mach number of the flow in region 1*/

parameter Real theta_deg(unit="deg")=15;/*deflection angle in degree for oblique shock*/
Real theta_rad(unit="rad");/*deflection angle in radian for oblique shock*/
parameter Real beta_deg(unit="deg")=20;/*wave angle in degree for oblique shock*/
Real beta_rad(unit="rad");/*wave angle in radian for oblique shock*/

Real M_n1;/*normal component of Mach number ahead of oblique shock*/


parameter Real p2_by_p1=13.32;/*ratio of static pressure of ahead and behind the oblique shock*/
parameter Real p02_by_p01=0.2322;/*ratio of total pressure of ahead and behind the oblique shock*/

parameter Real p01_by_p1=0.4244*10^5;/*ratio of total pressure and static pressure ahead of the oblique shock*/

parameter Real M_n2=0.4552;/*normal component of Mach number behind the oblique shock*/
Real M_2;/*Mach number of the stream behind the oblique shock or in region 2*/
Real p2(unit="atm");/*static pressure behind the oblique shock*/
Real p02(unit="atm");/*total pressure behind the oblique shock*/

equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);
beta_rad=Modelica.SIunits.Conversions.from_deg(beta_deg);

M_n1=M_1*sin(beta_rad);

M_2=M_n2/sin(beta_rad-theta_rad);

p2=p2_by_p1*p1;

p02=p02_by_p01*p01_by_p1*p1;

/*The  answer may slightly vary due to  rounding off values*/
end Ex9_10;
