class Ex9_6
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real M_1=5;/*Mach number of the flow*/

parameter Real theta_deg(unit="deg")=15;/*deflection angle in degree*/
Real theta_rad(unit="rad");/*deflection angle in radian*/
parameter Real beta_deg(unit="deg")=24.2;/*wave angle in degree*/
Real beta_rad(unit="rad");/*wave angle in radian*/

Real M_n1;/*normal component of Mach number ahead of shock*/

Real p_2_by_p_1;/*ratio of pressure of behind and ahead of the shock*/
Real c_d;/*drag coefficient*/

equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);
beta_rad=Modelica.SIunits.Conversions.from_deg(beta_deg);

M_n1=M_1*sin(beta_rad);

p_2_by_p_1=4.736;

c_d=((4*tan(theta_rad))/(gama*M_1^2))*(p_2_by_p_1-1);
end Ex9_6;
