class Ex1_3
/*pressure comversion from atm to N/m^2 1atm=1.01*10^5 N/m^2*/
/*pressure comversion from atm to lb/ft^2 1atm=2116 lb/ft^2*/

parameter Real p(unit="atm")=0.5;/*air pressure in atm*/
Real p1(unit="N/m^2");/*air pressure in SI unit*/
Real p2(unit="lb/ft^2");/*air pressure in fps unit*/

Real tau_T(unit="atm^(-1)");/*isothermal compressibility in per atm unit*/
Real tau_T1(unit="m^2/N");/*isothermal compressibility in SI unit*/
Real tau_T2(unit="ft^2/lb");/*isothermal compressibility in fps unit*/
equation
p1=p*1.01*10^5;
p2=p*2116;

tau_T=1/p;
tau_T1=1/p1;
tau_T2=1/p2;
end Ex1_3;
