class Ex1_4
parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant of Air*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real T(unit="K")=300;/*temperature of the air */
parameter Real M(unit="kg")=234.6;/*mass of the air inside the vessel*/
Real c_v(unit="J/(kg*K)");/*specific heat at constant volume*/

Real e(unit="J/kg");/*internal energy per unit mass*/
Real E(unit="J");/*total internal energy*/
equation
c_v=R/(gama-1);
e=c_v*T;
E=M*e;
end Ex1_4;
