class Ex3_12
/*pressure conversion from atm to N/m^2, 1 atm=1.01*10^5 N/m^2*/
parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure to specific heat at constant volume for air*/

parameter Real p1_atm(unit="atm")=0.5;/*pressure ahead of shock in atm unit*/
Real p1_SI(unit="N/m^2");/*pressure ahead of shock in SI unit*/
parameter Real T1(unit="K")=200;/*temperature ahead of shock*/
Real rho1(unit="kg/m^3");/*density ahead of shock*/

parameter Real p2_atm(unit="atm")=5.165;/*pressure behind the shock in atm unit*/
Real p2_SI(unit="N/m^2");/*pressure behind the shock in SI unit*/
parameter Real T2(unit="K")=535.8;/*temperature behind the shock*/
Real rho2(unit="kg/m^3");/*density behind the shock*/
Real rho2_rho1;/*ratio of density behind and ahead of shock*/
Real v1_v2;/*ratio of specefic volume ahead and behind of shock*/
Real p2_p1;/*ratio of pressure behind and ahead of shock from Hugoniot equation*/
equation
p1_SI=p1_atm*1.01*10^5;
p2_SI=p2_atm*1.01*10^5;

rho1=p1_SI/(R*T1);
rho2=p2_SI/(R*T2);
rho2_rho1=rho2/rho1;
v1_v2=rho2_rho1;

p2_p1=(((gama+1)/(gama-1))*v1_v2-1)/(((gama+1)/(gama-1))-v1_v2);
end Ex3_12;
