class Ex3_13
/*pressure conversion from atm to N/m^2, 1 atm=1.01*10^5 N/m^2*/

parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure to specific heat at constant volume for air*/

parameter Real M1=0.2;/*Entering Mach number of the air*/
parameter Real p1(unit="atm")=1;/*pressure of air at the entering point*/
parameter Real T1(unit="K")=273;/*temperature of air at the entering point*/
parameter Real q(unit="J/kg")=1.0*10^6;/*heating rate of air*/

parameter Real T01_T1=1.008;/*ratio of total temperature to static temperature at the entering point*/
parameter Real p01_p1=1.028;/*ratio of total pressure to static pressure at the entering point*/
Real T01(unit="K");/*total temperature at the entering point*/
Real p01(unit="atm");/*total pressure at the entering point*/
Real c_p(unit="J/(kg*K)");/*specific heat at constant pressure*/

Real T02(unit="K");/*total temperature at the exit point*/

parameter Real T1_Tstar=0.2066;/*ratio of static temperature to sonic temperature at the entering point*/
parameter Real p1_pstar=2.273;/*ratio of static pressure to sonic pressure at the entering point*/
parameter Real p01_p0star=1.235;/*ratio of total pressure to sonic total pressure at the entering point*/
parameter Real T01_T0star=0.1736;/*ratio of total temperature to sonic total temperature at the entering point*/

Real T02_T0star;/*ratio of total temperature to sonic total temperature at the exit point*/

parameter Real M2=0.58;/*exiting Mach number of the air*/

parameter Real T2_Tstar=0.8955;/*ratio of static temperature to sonic temperature at the exiting point*/
parameter Real p2_pstar=1.632;/*ratio of static pressure to sonic pressure at the exiting point*/
parameter Real p02_p0star=1.083;/*ratio of total pressure to sonic total pressure at the exiting point*/

Real p2(unit="atm");/*pressure of air at the exiting point*/
Real T2(unit="K");/*temperature of air at the exiting point*/
Real p02(unit="atm");/*total pressure of air at the exiting point*/
Real rho2(unit="kg/m^3");/*density of air at the exiting point*/
equation
T01=T01_T1*T1;
p01=p01_p1*p1;
c_p=(gama*R)/(gama-1);
T02=q/c_p+T01;
T02_T0star=(T02/T01)*T01_T0star;
T2=T2_Tstar*(1/T1_Tstar)*T1;
p2=p2_pstar*(1/p1_pstar)*p1;
p02=p02_p0star*(1/p01_p0star)*p01;
rho2=(p2*1.01*10^5)/(R*T2);/*here 1.01*10^5 has been multiplied with p2 to change the the unit from atm to N/m^2*/ 
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_13;
