class Ex3_15
parameter Real T01(unit="K")=840;/*total temperature before adding the heat*/
parameter Real T01_T0star=0.6540;/*ratio of total temperature before adding the heat to total temperature at choked condition*/

Real T0star(unit="K");/*total temperature at choked condition*/
Real T02(unit="K");/*total temperature after adding the heat*/

parameter Real c_p(unit="J/(kg*K)")=1004.5;/*specific heat at constant pressure*/
Real q(unit="J/kg");/*required heat for chocked condition*/
equation
T0star=T01/T01_T0star;
T02=T0star;
q=c_p*(T02-T01);

/*The  answer may slightly vary due to  rounding off values*/

end Ex3_15;
