class Ex3_6
parameter Real M1=2;/*Mach number of the missile*/
parameter Real p1(unit="lb/ft^2")=2116;/*pressure at sea level*/
parameter Real T1(unit="degR")=519;/*temperature at sea level*/

parameter Real T01_T1=1.8;/*ratio of free-stream total temperature to static temperature*/
parameter Real p01_p1=7.824;/*ratio of free-stream total pressure to static pressure*/
parameter Real p02_p01=0.7209;/*ratio of total pressure at the nose of the missile to free-stream total pressure*/

Real T01(unit="degR");/*free-stream total temperature*/
Real T02(unit="degR");/*total temperature at the nose*/
Real p02(unit="lb/ft^2");/*total pressure at the nose*/

equation
T01=T01_T1*T1;
T02=T01;

p02=p02_p01*p01_p1*p1;

/*The  answer may slightly vary due to  rounding off values*/

end Ex3_6;
