class Ex3_9
parameter Integer n=5;
parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant*/

parameter Real M1[n]={1.04,1.08,1.12,1.16,1.2};/*Mach number of the flow*/
parameter Real p02_p01[n]={0.9999,0.9994,0.9982,0.9961,0.9928};/*ratio of total pressure measured by pitot tube to free-stream total pressure*/

Real s2_s1[n](each unit="J/kg.K");/*change of specefic entropy */

algorithm
for i in 1:n loop
s2_s1[i]:=-R*log(p02_p01[i]);
end for;
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_9;
