class Ex4_10
parameter Real p1(unit="atm")=1;/*pressure ahead of oblique shock in atm unit*/ 
parameter Real T1(unit="degR")=519;/*Temperature ahead of oblique shock*/
parameter Real M_1=2.8;/*Mach number of the flow in region 1*/

parameter Real theta_deg1(unit="deg")=16;/*deflection angle in degree for oblique shock*/
Real theta_rad1(unit="rad");/*deflection angle in radian for oblique shock*/
parameter Real beta_deg1(unit="deg")=35;/*wave angle in degree for oblique shock*/
Real beta_rad1(unit="rad");/*wave angle in radian for oblique shock*/
Real M_n1;/*normal component of Mach number ahead of oblique shock*/

parameter Real p2_by_p1=2.82;/*ratio of pressure of ahead and behind the oblique shock*/
parameter Real T2_by_T1=1.388;/*ratio of temperature of ahead and behind the oblique shock*/
parameter Real M_n2=0.6684;/*normal component of Mach number behind the oblique shock*/

Real M_2;/*Mach number of the stream behind the oblique shock or in region 2*/
parameter Real beta_deg2(unit="deg")=45.5;/*wave angle in degree for reflected shock*/
Real beta_rad2(unit="rad");/*wave angle in radian for reflected shock*/

Real M_2n1;/*normal component of upstream Mach number relative to the reflected shock*/
parameter Real p3_by_p2=2.32;/*ratio of pressure of ahead and behind the reflected shock*/
parameter Real T3_by_T2=1.294;/*ratio of temperature of ahead and behind the reflected shock*/
parameter Real M_n3=0.7157;/*normal component of Mach number behind the reflected shock*/

Real M_3;/*Mach number of the stream behind the relected shock or in region 3*/
Real p3(unit="atm");/*pressure behind the relected shock*/ 
Real T3(unit="degR");/*Temperature behind the relected shock*/
Real phi(unit="deg");/*angle of the reflected shock wave relative to the straight wall*/

equation
theta_rad1=Modelica.SIunits.Conversions.from_deg(theta_deg1);
beta_rad1=Modelica.SIunits.Conversions.from_deg(beta_deg1);

M_n1=M_1*sin(beta_rad1);
M_2=M_n2/sin(beta_rad1-theta_rad1);

beta_rad2=Modelica.SIunits.Conversions.from_deg(beta_deg2);

M_2n1=M_2*sin(beta_rad2);

M_3=M_n3/sin(beta_rad2-theta_rad1);

p3=p3_by_p2*p2_by_p1*p1;
T3=T3_by_T2*T2_by_T1*T1;
phi=beta_deg2-theta_deg1;

/*The  answer may slightly vary due to  rounding off values*/

end Ex4_10;
