class Ex4_7
parameter Real gama=1.4;/*ratio of specific heat at constant pressure to specific heat at constant volume for air*/

parameter Real theta_deg(unit="deg")=10;/*deflection angle in degree(half-angle of wage)*/
Real theta_rad(unit="rad");/*deflection angle in radian(half-angle of wage)*/
parameter Real beta_deg(unit="deg")=44;/*wave angle in degree */
Real beta_rad(unit="rad");/*wave angle in radian*/

Real M1(start=1);/*free-stream Mach number*/
equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);
beta_rad=Modelica.SIunits.Conversions.from_deg(beta_deg);

tan(theta_rad)=2*(1/tan(beta_rad))*((M1^2*(sin(beta_rad))^2-1)/(M1^2*(gama+cos(2*beta_rad))+2));/*in the equation, cot(beta_rad) has been written as 1/tan(beta_rad) as cot command is not available in the modelica reference*/

end Ex4_7;
