class Ex5_3
/*Number-a*/
parameter Real gama=1.22;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real p_0(unit="atm")=25;/*pressure in the reservoir*/
parameter Real p_e(unit="atm")=1.174*10^(-2);/*pressure at the exit of the reservoir*/
Real M_e;/*Mach number at the exit*/

/*Number-b*/
parameter Real T_0(unit="K")=3517;/*temperature in the reservoir*/
Real T_e(unit="K");/*temperature at the exit*/
parameter Real R_U(unit="J/kg.mol.K")=8314;/*universal gas constant*/
parameter Real M(unit="mol")=16;/*molecular weight of the gas*/
Real R(unit="J/kg.K");/*specific gas constant*/
Real a_e(unit="m/s");/*speed of sound at exit*/
Real V_e(unit="m/s");/*flow velocity at exit*/
/*Number-c*/
parameter Real A_star(unit="m^2")=0.4;/*area of the throat*/
Real rho_0(unit="kg/m^3");/*density in the reservoir*/
Real rho_star(unit="kg/m^3");/*density in the throat*/
Real T_star(unit="K");/*temperature at the throat*/
Real a_star(unit="m/s");/*speed of sound at throat*/
Real m_dot(unit="kg/s");/*mass flow rate*/

/*Number-d*/
Real rho_e(unit="kg/m^3");/*density at the exit*/
Real A_e(unit="m^2");/*area at the exit*/
equation
/*Number-a*/
p_0/p_e=(1+((gama-1)/2)*M_e^2)^(gama/(gama-1));
/*Number-b*/
T_e/T_0=(p_e/p_0)^((gama-1)/gama);
R=R_U/M;
a_e=sqrt(gama*R*T_e);
V_e=M_e*a_e;
/*Number-c*/
rho_0=(p_0*1.01*10^5)/(R*T_0);/*here 1.01*10^5 is multiplied with p_0, to convert from atm to N/m^2*/
rho_star/rho_0=(2/(gama+1))^(1/(gama-1));
T_star/T_0=2/(gama+1);
a_star=sqrt(gama*R*T_star);
m_dot=rho_star*A_star*a_star;
/*Number-d*/
rho_e=(p_e*1.01*10^5)/(R*T_e);/*here 1.01*10^5 is multiplied with p_0, to convert from atm to N/m^2*/
A_e=m_dot/(rho_e*V_e);
end Ex5_3;
