class Ex1_2
/*pressure comversion from atm to N/m^2 1atm=1.01*10^5 N/m^2*/

parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant of Air*/

parameter Real v(unit="m^3")=10;/*volume of the vessel*/

parameter Real p_atm(unit="atm")=20;/*pressure inside vessel in atm*/
Real p(unit="N/m^2");/*pressure inside vessel in N/m^2*/

parameter Real T(unit="K")=300;/*temperature of the air */
Real rho(unit="kg/m^3");/*density of the air*/
Real M(unit="kg");/*mass of the air inside the vessel*/
equation
p=p_atm*1.01*10^5;
rho=p/(R*T);
M=rho*v;
end Ex1_2;
