class Ex1_6
parameter Real R1(unit="J/(kg.K)")=8314;/*universal gas constant*/
parameter Real M=12;/*molecular weight of the gas*/
Real R(unit="J/(kg.K)");/*Specific Gas Constant*/

parameter Real c_p(unit="J/(kg*K)")=4157;/*specific heat at constant pressure*/
Real c_v(unit="J/(kg*K)");/*specific heat at constant volume*/
Real gama;/*ratio of specific heat at constant pressure to specific heat at constant volume*/

parameter Real T1(unit="K")=2500;/*temperature at the combustion chaber*/
parameter Real T2(unit="K")=1350;/*temperature at the exit*/
parameter Real p1(unit="atm")=15;/*pressure in combustion chamber*/
Real p2(unit="atm");/*pressure at exit*/
equation
R=R1/M;
c_v=c_p-R;
gama=c_p/c_v;
p2/p1=(T2/T1)^(gama/(gama-1));
end Ex1_6;
