class Ex2_1
parameter Real V_inf(unit="m/s")=300;/*velocity of the airplane*/
parameter Real V_e(unit="m/s")=500;/*velocity of the exhust gas*/

parameter Real p_inf(unit="N/m^2")=2.65*10^4;/*free-stream pressure at 10 km altitude*/
parameter Real p_e(unit="N/m^2")=2.3*10^4;/*pressure of the exhust gas*/

parameter Real rho_inf(unit="kg/m^3")=0.414;/*free-stream density at 10 km altitude*/

parameter Real A_i(unit="m^2")=2;/*inlet area*/
parameter Real A_e(unit="m^2")=1;/*exit area*/

parameter Real f_t_a=0.05;/*fuel to air ratio*/

Real m_dot_i(unit="kg/s");/*mass flow of air through the inlet*/
Real m_dot_e(unit="kg/s");/*mass flow of air through the exit*/
Real T(unit="N");/*thrust of the engine*/
equation
m_dot_i=rho_inf*V_inf*A_i;
m_dot_e=(1+f_t_a)*m_dot_i;
T=m_dot_e*V_e-m_dot_i*V_inf+(p_e-p_inf)*A_e;
/*The  answer may slightly vary due to  rounding off values*/
end Ex2_1;
