class Ex3_11
parameter Real R_U(unit="J/(kg.K)")=8314;/*universal Gas Constant*/
parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant for air*/
parameter Real M=4;/*molecular weight off the helium gas*/
Real R_h(unit="J/(kg.K)");/*Specific Gas Constant for helium*/
parameter Real V1(unit="m/s")=1700;/*velocity of the both flow*/
parameter Real T1(unit="K")=288;/*temperature of the both flow*/

parameter Real gama_a=1.4;/*ratio of specific heat at constant pressure to specific heat at constant volume for air*/
parameter Real gama_h=1.67;/*ratio of specific heat at constant pressure to specific heat at constant volume for helium gas*/

Real a_a(unit="m/s");/*speed of sound through air*/
Real a_h(unit="m/s");/*speed of sound through helium*/
Real M1_a;/*Mach number of the air flow*/
Real M1_h;/*Mach number of the helium flow*/

Real p2_p1_a;/*ratio of static pressure behind and ahead of the shock for air*/
Real p2_p1_h;/*ratio of static pressure behind and ahead of the shock for helium gas*/
equation
a_a=sqrt(gama_a*R*T1);
M1_a=V1/a_a;
p2_p1_a=29;

R_h=R_U/M;
a_h=sqrt(gama_h*R_h*T1);
M1_h=V1/a_h;
p2_p1_h=1+((2*gama_h)/(gama_h+1))*(M1_h^2-1);
end Ex3_11;
