class Ex3_4
/*pressure conversion from atm to N/m^2, 1atm=1.01*10^5 N/m^2*/

parameter Real R(unit="J/(kg.K)")=692.8;/*Specific Gas Constant*/

parameter Real p2_atm(unit="atm")=0.372;/*pressure at exit in atm unit*/
Real p2(unit="N/m^2");/*pressure at exit in SI unit*/
parameter Real T2(unit="K")=1350;/*temperature at the exit*/
parameter Real T(unit="N")=4.5*10^5;/*thrust*/
parameter Real V2(unit="m/s")=3092;/*exit velocity*/
Real m_dot(unit="kg/s");/*mass flow rate through the engine*/

Real rho_2(unit="kg/m^3");/*temperature at the exit*/
Real A2(unit="m^2");/*area of the exit*/
equation
T=m_dot*V2;
p2=p2_atm*1.01*10^5;
rho_2=p2/(R*T2);
m_dot=rho_2*A2*V2;
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_4;
