class Ex4_1
parameter Real M_1=3;/*Mach number of the supersonic flow*/
parameter Real p_1(unit="atm")=1;/*pressure ahead of shock*/
parameter Real T_1(unit="K")=288;/*temperature ahead of shock*/

parameter Real theta_deg(unit="deg")=20;/*deflection angle in degree*/
Real theta_rad(unit="rad");/*deflection angle in radian*/
parameter Real beta_deg(unit="deg")=37.8;/*wave angle in degree*/
Real beta_rad(unit="rad");/*wave angle in radian*/
Real M_n1;/*normal component of Mach number ahead of shock*/

parameter Real p_2_by_p_1=3.783;/*ratio of pressure of ahead and behind of the shock*/
parameter Real T_2_by_T_1=1.562;/*ratio of temperature of ahead and behind of the shock*/
parameter Real M_n2=0.6078;/*normal component of Mach number behind of shock*/
parameter Real p_02_by_p_01=0.7948;/*ratio of total pressure of ahead and behind of the shock*/

Real p_2(unit="atm");/*pressure behind of shock*/
Real T_2(unit="K");/*temperature behind of shock*/
Real M_2;/*Mach number of the stream behind the shock*/

parameter Real p_01_by_p_1=36.73;/*ratio of total pressure of ahead of shock and static pressure behind the shock*/
parameter Real T_01_by_T_1=2.8;/*ratio of total temperature of ahead of shock and static temperature behind the shock*/

Real p_02(unit="atm");/*total pressure behind of shock*/
Real T_02(unit="K");/*total temperature behind of shock*/

equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);
beta_rad=Modelica.SIunits.Conversions.from_deg(beta_deg);
M_n1=M_1*sin(beta_rad);

p_2=p_2_by_p_1*p_1;
T_2=T_2_by_T_1*T_1;
M_2=M_n2/sin(beta_rad-theta_rad);

p_02=p_02_by_p_01*p_01_by_p_1*p_1;
T_02=T_01_by_T_1*T_1;

end Ex4_1;
