class Ex4_3
parameter Real M_1=5;/*Mach number of the supersonic flow*/
parameter Real p_1(unit="atm")=1;/*pressure ahead of shock*/

parameter Real theta_deg(unit="deg")=20;/*deflection angle in degree*/
Real theta_rad(unit="rad");/*deflection angle in radian*/
parameter Real beta_deg(unit="deg")=30;/*wave angle in degree*/
Real beta_rad(unit="rad");/*wave angle in radian*/
Real M_n1;/*normal component of Mach number ahead of shock*/

parameter Real p_2_by_p_1=7.125;/*ratio of pressure of ahead and behind of the shock*/
parameter Real M_n2=0.513;/*normal component of Mach number behind the shock*/

Real p_2(unit="atm");/*pressure behind of shock*/
Real M_2;/*Mach number of the stream behind the shock*/

equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);
beta_rad=Modelica.SIunits.Conversions.from_deg(beta_deg);
M_n1=M_1*sin(beta_rad);

p_2=p_2_by_p_1*p_1;
M_2=M_n2/sin(beta_rad-theta_rad);

end Ex4_3;
