class Ex4_4
parameter Real M_1=2.8;/*Mach number of the flow both cases*/

/*for case 1*/
parameter Real theta_deg_1(unit="deg")=15;/*deflection angle in degree for case 1*/
Real theta_rad_1(unit="rad");/*deflection angle in radian for case 1*/
parameter Real beta_deg_1(unit="deg")=33.8;/*wave angle in degree for case 1*/
Real beta_rad_1(unit="rad");/*wave angle in radian for case 1*/
Real M_n1_1;/*normal component of Mach number ahead of shock for case 1*/

Real p2_by_p1_1;/*ratio of pressure of ahead and behind of the shock for case 1*/

/*for case 2*/
parameter Real theta_deg_2(unit="deg")=30;/*deflection angle in degree for case 2*/
Real theta_rad_2(unit="rad");/*deflection angle in radian for case 2*/
parameter Real beta_deg_2(unit="deg")=54.7;/*wave angle in degree for case 2*/
Real beta_rad_2(unit="rad");/*wave angle in radian for case 2*/
Real M_n1_2;/*normal component of Mach number ahead of shock for case 2*/

Real p2_by_p1_2;/*ratio of pressure of ahead and behind of the shock for case 2*/


equation
/*for case 1*/
theta_rad_1=Modelica.SIunits.Conversions.from_deg(theta_deg_1);
beta_rad_1=Modelica.SIunits.Conversions.from_deg(beta_deg_1);
M_n1_1=M_1*sin(beta_rad_1);
p2_by_p1_1=2.673;

/*for case 2*/
theta_rad_2=Modelica.SIunits.Conversions.from_deg(theta_deg_2);
beta_rad_2=Modelica.SIunits.Conversions.from_deg(beta_deg_2);
M_n1_2=M_1*sin(beta_rad_2);
p2_by_p1_2=6.005;

end Ex4_4;
