class Ex4_8
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real M1=3;/*Mach number of the flow*/

parameter Real theta_deg(unit="deg")=15;/*deflection angle in degree(half angle of the wedge)*/
Real theta_rad(unit="rad");/*deflection angle in radian(half angle of the wedge)*/
parameter Real beta_deg(unit="deg")=32.2;/*wave angle in degree*/
Real beta_rad(unit="rad");/*wave angle in radian*/

Real M_n1;/*normal component of Mach number ahead of shock*/

Real p2_by_p1;/*ratio of pressure of behind and ahead of the shock*/
Real c_p;/*pressure coefficient*/

equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);
beta_rad=Modelica.SIunits.Conversions.from_deg(beta_deg);

M_n1=M1*sin(beta_rad);

p2_by_p1=2.82;

c_p=(2/(gama*M1^2))*(p2_by_p1-1);

end Ex4_8;
