class Ex5_1
parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant of Air*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real A_by_Astar=6;/*exit to throat area ratio*/
parameter Real T0(unit="K")=300;/*temperature in the reservoir*/
parameter Real p0(unit="atm")=10;/*pressure in the reservoir*/

/*for section 1*/
parameter Real M1=0.097;/*Mach number at the section 1*/
parameter Real p0_p1=1.006;/*ratio of total pressure to static pressure at section 1*/
parameter Real T0_T1=1.002;/*ratio of total temperature to static temperature at section 1*/


Real p1(unit="atm");/*pressure at section 1*/
Real T1(unit="K");/*temperature at section 1*/
Real a1(unit="m/s");/*speed of sound at section 1*/
Real u1(unit="m/s");/*flow velocity at section 1*/

/*for section 2*/
parameter Real M2=3.368;/*Mach number at the section 2*/
parameter Real p0_p2=63.13;/*ratio of total pressure to static pressure at section 2*/
parameter Real T0_T2=3.269;/*ratio of total temperature to static temperature at section 2*/


Real p2(unit="atm");/*pressure at section 2*/
Real T2(unit="K");/*temperature at section 2*/
Real a2(unit="m/s");/*speed of sound at section 2*/
Real u2(unit="m/s");/*flow velocity at section 2*/
equation
/*for section 1*/
p1=(1/p0_p1)*p0;
T1=(1/T0_T1)*T0;
a1=sqrt(gama*R*T1);
u1=M1*a1;

/*for section 2*/
p2=(1/p0_p2)*p0;
T2=(1/T0_T2)*T0;
a2=sqrt(gama*R*T2);
u2=M2*a2;

end Ex5_1;
