class Ex7_1
/*Number-a*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real T1(unit="K")=300;/*temperature of the stagnate air*/
Real a1(unit="m/s");/*speed of sound in the ambient air*/
parameter Real p2_p1=10;/*pressure ratio across the shock*/
Real W(unit="m/s");/*shock wave velocity*/
Real u_p(unit="m/s");/*induced mass motion behind the shock*/
Real T2_T1;/*temperature ratio across the wave*/
equation
a1=sqrt(gama*R*T1);
W=a1*sqrt(((gama+1)/(2*gama))*(p2_p1-1)+1);
u_p=(a1/gama)*(p2_p1-1)*(((2*gama)/(gama+1))/(p2_p1+((gama-1)/(gama+1))))^(1/2);
T2_T1=p2_p1*((((gama+1)/(gama-1))+p2_p1)/(1+(((gama+1)/(gama-1))*p2_p1)));

/*The  answer may slightly vary due to  rounding off values*/
end Ex7_1;
