class Ex7_2
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
Real c_p(unit="J/kg.K");/*specific heat at constant pressure*/

parameter Real T1(unit="K")=300;/*temperature of the stagnate air ahead of the shock*/
parameter Real T2_T1=2.623;/*temperature ratio across the wave*/
Real T2(unit="K");/*temperature of the gas behind the shock*/

parameter Real u_p1(unit="m/s")=0;/*air motion ahead of the shock*/
parameter Real u_p2(unit="m/s")=756.2;/*induced mass motion behind the shock*/

Real h01(unit="J/kg");/*enthalpy ahead of shock*/
Real h02(unit="J/kg");/*enthalpy behind of shock*/
Real h02_h01(unit="J/kg");/*change of enthalpy across the shock*/
equation
c_p=(gama*R)/(gama-1);
h01=c_p*T1+u_p1^2/2;
T2=T2_T1*T1;
h02=c_p*T2+u_p2^2/2;
h02_h01=h02-h01;
/*The  answer may slightly vary due to  rounding off values*/
end Ex7_2;
