class Ex7_5
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real M_s=2.95;/*Mach number of incident shock*/
Real M_R(start=1.1);/*Mach number of reflected shock*/

Real p5_p2;/*pressure ratio across the reflected shock*/

parameter Real T5_T2=1.77;/*temperature ratio across the reflected shock*/
parameter Real T1(unit="K")=300;/*temperature of the stagnate air ahead of incident shock*/
parameter Real T2_T1=2.623;/*temperature ratio across the incident shock*/
Real T5(unit="K");/*temperature behind the reflected shock*/
equation
M_R/(M_R^2-1)=(M_s/(M_s^2-1))*sqrt(1+(2*(gama-1)/(gama+1)^2)*((M_s^2-1))*(gama+(1/M_s^2)));

p5_p2=4.978;
T5=T5_T2*T2_T1*T1;
/*The  answer may slightly vary due to  rounding off values*/
end Ex7_5;
