class Ex2_2
parameter Real V_e(unit="m/s")=4000;/*velocity of the exhust gas*/

parameter Real p_inf(unit="N/m^2")=0.584*10^3;/*free-stream pressure at 10 km altitude*/
parameter Real p_e(unit="N/m^2")=1.2*10^3;/*pressure of the exhust gas*/

parameter Real A_e(unit="m^2")=12;/*exit area*/

parameter Real h_r(unit="kg/s")=11;/*pumping rate of hydrogen*/
parameter Real o_r(unit="kg/s")=89;/*pumping rate of oxyzen*/

Real m_dot_t(unit="kg/s");/*total pumping rate at combustion chamber*/
Real m_dot_e(unit="kg/s");/*mass flow of air through the exit*/
Real T(unit="N");/*thrust of the engine*/
equation
m_dot_t=h_r+o_r;
m_dot_e=m_dot_t;
T=m_dot_e*V_e+(p_e-p_inf)*A_e;
/*The  answer may slightly vary due to  rounding off values*/
end Ex2_2;
