class Ex3_14
/*pressure conversion from atm to N/m^2, 1 atm=1.01*10^5 N/m^2*/

parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure to specific heat at constant volume for air*/

parameter Real M1=3;/*Entering Mach number of the air*/
parameter Real p1(unit="atm")=1;/*pressure of air at the entering point*/
parameter Real T1(unit="K")=300;/*temperature of air at the entering point*/
parameter Real q(unit="J/kg")=3*10^5;/*heating rate of air*/

parameter Real T01_T1=2.8;/*ratio of total temperature to static temperature at the entering point*/
Real T01(unit="K");/*total temperature at the entering point*/
Real c_p(unit="J/(kg*K)");/*specific heat at constant pressure*/

Real T02(unit="K");/*total temperature at the exit point*/

parameter Real T1_Tstar=0.2803;/*ratio of static temperature to sonic temperature at the entering point*/
parameter Real p1_pstar=0.1765;/*ratio of static pressure to sonic pressure at the entering point*/
parameter Real T01_T0star=0.6540;/*ratio of total temperature to sonic total temperature at the entering point*/

Real T02_T0star;/*ratio of total temperature to sonic total temperature at the exit point*/

parameter Real M2=1.58;/*exiting Mach number of the air*/

parameter Real T2_Tstar=0.7117;/*ratio of static temperature to sonic temperature at the exiting point*/
parameter Real p2_pstar=0.5339;/*ratio of static pressure to sonic pressure at the exiting point*/

parameter Real p01_p0star=3.424;/*ratio of total pressure to sonic total pressure at the entering point*/
parameter Real p02_p0star=1.164;/*ratio of total pressure to sonic total pressure at the exiting point*/
parameter Real p01_p1=36.73;/*ratio of total pressure to static pressure at the entering point*/
Real p02_p01;/*ratio of total pressure after and before heating*/

Real p2(unit="atm");/*pressure of air at the exiting point*/
Real T2(unit="K");/*temperature of air at the exiting point*/
Real rho2(unit="kg/m^3");/*density of air at the exiting point*/

Real p02(unit="atm");/*total pressure of air at the exiting point*/

equation
T01=T01_T1*T1;

c_p=(gama*R)/(gama-1);
T02=q/c_p+T01;

T02_T0star=(T02/T01)*T01_T0star;

T2=T2_Tstar*(1/T1_Tstar)*T1;
p2=p2_pstar*(1/p1_pstar)*p1;
rho2=(p2*1.01*10^5)/(R*T2);/*here 1.01*10^5 has been multiplied with p2 to change the the unit from atm to N/m^2*/

p02_p01=p02_p0star/p01_p0star;
p02=p02_p01*p01_p1*p1;
 
/*The  answer may slightly vary due to  rounding off values*/

end Ex3_14;
