class Ex3_17
parameter Real D(unit="m")=0.15;/*inside diameter of the pipe*/
parameter Real L(unit="m")=30;/*length of the pipe*/

parameter Real M1=0.3;/*Mach number of the flow at inlet*/
parameter Real p1(unit="atm")=1;/*static pressure of the flow at inlet*/
parameter Real T1(unit="K")=273;/*static temperature of the flow at inlet*/
parameter Real f=0.005;/*friction coefficient*/

parameter Real p01_p1=1.064;/*ratio of total pressure to static pressure at the inlet*/
Real p01(unit="atm");/*total pressure at the inlet*/

parameter Real Four_f_star_L1_D=5.299;/*inlet value*/
parameter Real p1_pstar=3.169;/*ratio of inlet static pressure to pressure at choking cndition*/
parameter Real T1_Tstar=1.179;/*ratio of inlet static temperature to temperature at choking cndition*/
parameter Real p01_p0star=2.035;/*ratio of inlet total pressure to total pressure at choking cndition*/

Real Four_f_star_L2_D;/*outlet value*/
parameter Real M2=0.475;/*Mach number at outlet*/

parameter Real p2_pstar=2.258;/*ratio of outlet static pressure to pressure at choking cndition*/
parameter Real T2_Tstar=1.148;/*ratio of outlet static temperature to temperature at choking cndition*/
parameter Real p02_p0star=1.392;/*ratio of outlet total pressure to total pressure at choking cndition*/

Real p2(unit="atm");/*static pressure of the flow at outlet*/
Real T2(unit="K");/*temperature of the flow at outlet*/
Real p02(unit="atm");/*total pressure of the flow at outlet*/
equation
p01=p01_p1*p1;

Four_f_star_L2_D=Four_f_star_L1_D-(4*f*L)/D;

p2=p2_pstar*(1/p1_pstar)*p1;
T2=T2_Tstar*(1/T1_Tstar)*T1;
p02=p02_p0star*(1/p01_p0star)*p01;
end Ex3_17;
