class Ex3_2
parameter Real R(unit="J/(kg.K)")=692.8;/*Specific Gas Constant*/
parameter Real gama=1.2;/*ratio of specific heat at constant pressure to specific heat at constant volume*/

parameter Real T2(unit="K")=1350;/*temperature at the exit*/

parameter Real p0(unit="atm")=15;/*pressure in combustion chamber or total pressure*/
parameter Real p2(unit="atm")=0.372;/*pressure at exit*/

Real M2;/*Mach number at the exit*/
Real a2(unit="m/s");/*speed of sound at the exit*/
Real V2(unit="m/s");/*VELOCITY at the exit*/
equation
M2=sqrt((2/(gama-1))*((p0/p2)^((gama-1)/gama)-1));
a2=sqrt(gama*R*T2);
V2=M2*a2;
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_2;
