class Ex3_3
/*velocity conversion from mile per hour to foot per second 60 mi/h=88 ft/s,*/

parameter Real R(unit="(ft.lb)/(slug.degR)")=1716;/*Specific Gas Constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure to specific heat at constant volume*/

parameter Real rho1(unit="slug/ft^3")=0.002377;/*sea level free-stream density*/
parameter Real T1(unit="degR")=519;/*free-stream temperature*/

parameter Real V1_mi_h(unit="mi/h")=100;/*free-stream velocity in mile per hour*/
Real V1(unit="ft/s");/*free-stream velocity in foot per second*/

parameter Real V2_mi_h(unit="mi/h")=150;/* velocity on the wing in mile per hour*/
Real V2(unit="ft/s");/*velocity on the wing in foot per second*/

Real c_p(unit="ft.lb/(slug*degR)");/*specific heat at constant pressure*/

Real T2(unit="degR");/*temperature at wing*/

Real rho2(unit="slug/ft^3");/*density at the wing*/
Real d_rho;/*percentage change of density*/
equation
V1=V1_mi_h*(88/60);
V2=V2_mi_h*(88/60);

c_p=(gama*R)/(gama-1);
c_p*T1+V1^2/2=c_p*T2+V2^2/2;
rho2/rho1=(T2/T1)^(1/(gama-1));
d_rho=(rho1-rho2)/rho1;
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_3;
