class Ex4_6
parameter Real pi = Modelica.Constants.pi;
parameter Real gama=1.4;/*ratio of specific heat at constant pressure to specific heat at constant volume for air*/

parameter Real M=4;/*Mach number of the flow*/

parameter Real theta_deg(unit="deg")=32;/*deflection angle in degree*/
Real theta_rad(unit="rad");/*deflection angle in radian*/

Real lamda;
Real chi;

parameter Real delta_w=1;/*for weak shock solution*/

Real beta_rad_w(unit="rad");/*wave angle in radian for weak shock*/
Real beta_deg_w(unit="deg");/*wave angle in degree for weak shock*/

equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);

lamda=((M^2-1)^2-3*(1+((gama-1)/2)*M^2)*(1+((gama+1)/2)*M^2)*(tan(theta_rad))^2)^(1/2);

chi=((M^2-1)^3-9*(1+((gama-1)/2)*M^2)*(1+((gama-1)/2)*M^2+((gama+1)/4)*M^4)*(tan(theta_rad))^2)/lamda^3;

tan(beta_rad_w)=(M^2-1+2*lamda*cos((4*pi*delta_w+acos(chi))/3))/(3*(1+((gama-1)/2)*M^2)*tan(theta_rad));
beta_deg_w=Modelica.SIunits.Conversions.to_deg(beta_rad_w);
/*The  answer may slightly vary due to  rounding off values*/
end Ex4_6;
