class Ex4_9
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real M1=3;/*Mach number of the flow*/

parameter Real theta_deg(unit="deg")=15;/*deflection angle in degree(half angle of the wedge)*/
Real theta_rad(unit="rad");/*deflection angle in radian(half angle of the wedge)*/

Real p2_by_p1;/*ratio of pressure of behind and ahead of the shock*/
Real c_d;/*drag coefficient*/

equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);

p2_by_p1=2.82;

c_d=(4/(gama*M1^2))*(p2_by_p1-1)*tan(theta_rad);
end Ex4_9;
