class Ex7_4
parameter Real c_p(unit="J/kg.K")=1004.5;/*specific heat at constant pressure*/

parameter Real T1(unit="K")=300;/*temperature of the stagnate air ahead of the shock*/
parameter Real T2(unit="K")=786.9;/*temperature of the gas behind the shock*/

parameter Real V1(unit="m/s")=200;/*velocity of the air ahead of the shock relative to the laboratory*/
parameter Real V2(unit="m/s")=556.2;/*velocity of the air behind of the shock relative to the laboratory*/

Real h01(unit="J/kg");/*enthalpy ahead of shock(unit provided for h_01 in the book is wrong)*/
Real h02(unit="J/kg");/*enthalpy behind of shock(unit provided for h_02 in the book is wrong)*/
Real h02_h01(unit="J/kg");/*change of enthalpy across the shock*/
equation
h01=c_p*T1+V1^2/2;
h02=c_p*T2+V2^2/2;

h02_h01=h02-h01;
/*The  answer may slightly vary due to  rounding off values*/
end Ex7_4;
