class Ex1_5
/*pressure comversion from atm to N/m^2 1atm=1.01*10^5 N/m^2*/

parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant of Air*/

parameter Real T1(unit="K")=300;/*temperature of the air before heating */
parameter Real T2(unit="K")=600;/*temperature of the air after heating */

parameter Real p_atm(unit="atm")=20;/*pressure inside vessel in atm before heating*/
Real p1(unit="N/m^2");/*pressure inside vessel in N/m^2 before heating*/
Real p2(unit="N/m^2");/*pressure inside vessel in N/m^2 after heating*/

parameter Real c_v(unit="J/(kg*K)")=717.5;/*specific heat at constant volume*/
Real c_p(unit="J/(kg*K)");/*specific heat at constant pressure*/

parameter Real M(unit="kg")=234.6;/*mass of the air inside the vessel*/

Real s2_s1(unit="J/kg.K");/*change in entropy per unit mass*/
Real S2_S1(unit="J/K");/*total change in entropy */
equation
p1=p_atm*1.01*10^5;
p2/p1=T2/T1;
c_p=c_v+R;
s2_s1=c_p*log(T2/T1)-R*log(p2/p1);
S2_S1=M*s2_s1;

/*The  answer may slightly vary due to  rounding off values*/
end Ex1_5;
