class Ex3_16
parameter Real c_p(unit="J/(kg*K)")=1004.5;/*specific heat at constant pressure*/

parameter Real q(unit="J/kg")=6*10^5;/*heat added to the system*/
parameter Real T01(unit="K")=840;/*total temperature before adding the heat*/

Real T02(unit="K");/*total temperature after adding the heat*/
Real T0star(unit="K");/*total temperature at choked condition*/

Real T01_T0star;/*ratio of total temperature before adding the heat to total temperature at choked condition*/
Real M1;/*initial Mach number of the flow*/
equation
q=c_p*(T02-T01);
T0star=T02;
T01_T0star=T01/T0star;
M1=0.43;
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_16;
