class Ex3_5
parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure to specific heat at constant volume*/

parameter Real M1=3;/*Mach number of the flow ahead of shock*/
parameter Real p1(unit="atm")=0.5;/*pressure ahead of the shock*/
parameter Real T1(unit="K")=200;/*temperature ahead of the shock*/

parameter Real p2_p1=10.33;/*ratio of pressure ahead and behind the shock*/
parameter Real T2_T1=2.679;/*ratio of temperature ahead and behind the shock*/
parameter Real M2=0.4752;/*Mach number of the flow behind the shock*/

Real p2(unit="atm");/*pressure behind the shock*/
Real T2(unit="K");/*temperature behind the shock*/
Real a2(unit="m/s");/*speed of sound behind the shock*/
Real u2(unit="m/s");/*velocity of the flow behind the shock*/
equation
p2=p2_p1*p1;
T2=T2_T1*T1;
a2=sqrt(gama*R*T2);
u2=M2*a2;
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_5;
