class Ex4_17
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real M1=3;/*Mach number of the flow*/

parameter Real theta_deg(unit="deg")=15;/*deflection angle in degree(half angle of the wedge)*/
Real theta_rad(unit="rad");/*deflection angle in radian(half angle of the wedge)*/
parameter Real beta_deg(unit="deg")=32.2;/*wave angle in degree*/
Real beta_rad(unit="rad");/*wave angle in radian*/

Real M_n1;/*normal component of Mach number ahead of shock*/
parameter Real M_n2=0.6684;/*normal component of Mach number behind the shock*/
Real M_2;/*Mach number of the stream behind the oblique shock*/
Real p2_by_p1;/*ratio of pressure of behind and ahead of the shock*/

parameter Real p02_by_p2=11.75;/*ratio of total pressure to static pressure behind of expansion wave*/

parameter Real nu2(unit="deg")=33.27;/*value of the Prandtl-Meyer function ahead of expansion wave*/
Real nu3(unit="deg");/*value of the Prandtl-Meyer function behind the expansion wave*/

parameter Real M_3=3.82;/*Mach number of the flow behind of expansion wave*/
parameter Real p03_by_p3=119.1;/*ratio of total pressure to static pressure behind the expansion wave*/

Real p3_by_p1;/*ratio of static pressure in region 1 to static pressure in region 3*/
Real pB_by_p1;/*ratio of back pressure of the wedge to static pressure in region 1*/ 
Real c_d;/*drag coefficient*/

equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);
beta_rad=Modelica.SIunits.Conversions.from_deg(beta_deg);

M_n1=M1*sin(beta_rad);
M_2=M_n2/sin(beta_rad-theta_rad);

p2_by_p1=2.82;

nu3=nu2+30;
p3_by_p1=(1/p03_by_p3)*p02_by_p2*p2_by_p1;
pB_by_p1=(1/2)*(1+p3_by_p1);
c_d=(4/(gama*M1^2))*(p2_by_p1-pB_by_p1)*tan(theta_rad);

end Ex4_17;
