class Ex7_3
parameter Real W(unit="m/s")=1024.9;/*shock wave velocity*/
parameter Real v_a(unit="m/s")=200;/*velocity of the air ahead of the shock relative to the laboratory*/
Real u_w(unit="m/s");/*velocity of wave relative to the laboratory*/

parameter Real u_p(unit="m/s")=756.2;/*induced mass motion behind the shock*/
Real u_gs(unit="m/s");/*velocity of the gas behind the shock relative to the shock*/
Real v_gl(unit="m/s");/*velocity of gas behind the wave relative to the laboratory*/
equation
u_w=W-v_a;
u_gs=W-u_p;
v_gl=u_w-u_gs;
end Ex7_3;
