class Ex1_1
/*velocity conversion from mile per hour to foot per second 60 mi/h=88 ft/s,*/

parameter Real p1(unit="lb/ft^2")=2116;/*free-stream pressure*/
parameter Real rho(unit="slug/ft^3")=0.002377;/*sea level free-stream density*/

parameter Real V1_mi_h(unit="mi/h")=100;/*free-stream velocity in mile per hour*/
Real V1_ft_s(unit="ft/s");/*free-stream velocity in foot per second*/

parameter Real V2_mi_h(unit="mi/h")=150;/*maximum velocity on the wing in mile per hour*/
Real V2_ft_s(unit="ft/s");/*maximum velocity on the wing in foot per second*/

Real p1_p2(unit="lb/ft^2");/*pressure difference*/
Real p_cp;/*percentage change of preesure*/

equation
V1_ft_s=V1_mi_h*(88/60);
V2_ft_s=V2_mi_h*(88/60);

p1_p2=(1/2)*rho*(V2_ft_s^2-V1_ft_s^2);
p_cp=(p1_p2/p1)*100;
end Ex1_1;
