class Ex1_7
/*pressure comversion from atm to N/m^2 1atm=1.01*10^5 N/m^2*/

parameter Real gama=1.4;/*ratio of specific heat at constant pressure to specific heat at constant volume*/

parameter Real p(unit="atm")=0.5;/*air pressure in atm*/
Real p1(unit="N/m^2");/*air pressure in SI unit*/

Real tau_T(unit="m^2/N");/*isothermal compressibility*/
Real tau_s(unit="m^2/N");/*isntrophic compressibility in*/

equation
p1=p*1.01*10^5;

tau_T=1/p1;
tau_s=tau_T/gama;

end Ex1_7;
