class Ex3_1
parameter Real R(unit="(ft.lb)/(slug.degR)")=1716;/*Specific Gas Constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure to specific heat at constant volume*/

parameter Real p(unit="lb/ft^2")=1890;/*static pressure of the flow*/
parameter Real T(unit="degR")=450;/*static temperature of the flow*/
parameter Real M=1.5;/*Mach number of flow*/

parameter Real p0_p=3.671;/*ratio of total pressure to static pressure*/
parameter Real T0_T=1.45;/*ratio of total temperature to static temperature*/

Real p0(unit="lb/ft^2");/*total pressure of the flow*/
Real T0(unit="degR");/*total temperature of the flow*/

parameter Real p0_p_star=1.893;/*ratio of total pressure to pressure at sonic condition*/
parameter Real T0_T_star=1.2;/*ratio of total temperature to temperature at sonic condition*/

Real p_star(unit="lb/ft^2");/*pressure of the flow at sonic condition*/
Real T_star(unit="degR");/*temperature of the flow at sonic condition*/

Real a(unit="ft/s");/*speed of sound*/
Real V(unit="ft/s");/*velocity of the flow*/
equation
p0=p0_p*p;
T0=T0_T*T;
p_star=(1/p0_p_star)*p0_p*p;
T_star=(1/T0_T_star)*T0_T*T;
a=sqrt(gama*R*T);
V=M*a;
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_1;
