class Ex3_18
parameter Real D(unit="ft")=0.4;/*inside diameter of the pipe*/
parameter Real L(unit="ft")=5;/*length of the pipe*/

parameter Real M1=3;/*Mach number of the flow at inlet*/
parameter Real p1(unit="atm")=1;/*static pressure of the flow at inlet*/
parameter Real T1(unit="K")=300;/*static temperature of the flow at inlet*/
parameter Real f=0.005;/*friction coefficient*/

parameter Real Four_f_star_L1_D=0.5222;/*inlet value*/
parameter Real p1_pstar=0.2182;/*ratio of inlet static pressure to pressure at choking cndition*/
parameter Real T1_Tstar=0.4286;/*ratio of inlet static temperature to temperature at choking cndition*/

Real Four_f_star_L2_D;/*outlet value*/
parameter Real M2=1.9;/*Mach number at outlet*/

parameter Real p2_pstar=0.4394;/*ratio of outlet static pressure to pressure at choking cndition*/
parameter Real T2_Tstar=0.6969;/*ratio of outlet static temperature to temperature at choking cndition*/

Real T2(unit="K");/*temperature of the flow at outlet*/
Real p2(unit="atm");/*static pressure of the flow at outlet*/

parameter Real p01_p0star=4.235;/*ratio of inlet total pressure to total pressure at choking cndition*/
parameter Real p02_p0star=1.555;/*ratio of outlet total pressure to total pressure at choking cndition*/
Real p02_p01;/*ratio of outlet total pressure to inlet total pressure*/

parameter Real p01_p1=36.73;/*ratio of total pressure to static pressure at the inlet*/
Real p02(unit="atm");/*total pressure of the flow at outlet*/

equation

Four_f_star_L2_D=Four_f_star_L1_D-(4*f*L)/D;

T2=T2_Tstar*(1/T1_Tstar)*T1;
p2=p2_pstar*(1/p1_pstar)*p1;

p02_p01=p02_p0star/p01_p0star;
p02=p02_p01*p01_p1*p1;

end Ex3_18;
