class Ex4_5
parameter Real theta_deg(unit="deg")=28;/*deflection angle in degree for both cases*/

/*for case 1*/
parameter Real M1_1=3;/*Mach number of the flow for case 1*/
parameter Real beta_deg_1(unit="deg")=48.5;/*wave angle in degree for case 1*/
Real beta_rad_1(unit="rad");/*wave angle in radian for case 1*/
Real M_n1_1;/*normal component of Mach number ahead of shock for case 1*/

Real p2_by_p1_1;/*ratio of pressure of ahead and behind of the shock for case 1*/

/*for case 2*/
parameter Real M1_2=6;/*Mach number of the flow for case 2*/
parameter Real beta_deg_2(unit="deg")=38;/*wave angle in degree for case 2*/
Real beta_rad_2(unit="rad");/*wave angle in radian for case 2*/
Real M_n1_2;/*normal component of Mach number ahead of shock for case 2*/

Real p2_by_p1_2;/*ratio of pressure of ahead and behind of the shock for case 2*/


equation
/*for case 1*/
beta_rad_1=Modelica.SIunits.Conversions.from_deg(beta_deg_1);
M_n1_1=M1_1*sin(beta_rad_1);
p2_by_p1_1=5.74;

/*for case 2*/
beta_rad_2=Modelica.SIunits.Conversions.from_deg(beta_deg_2);
M_n1_2=M1_2*sin(beta_rad_2);
p2_by_p1_2=15.8;

end Ex4_5;
