class Ex5_7
/*Number-b*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real Ae_At=3;/*exit to throat area ratio*/
Real Ae_A1star;/*ratio of exit to area at sonic condition of ahead of shock*/
parameter Real P01(unit="atm")=1;/*pressure in the reservoir*/
parameter Real Pe(unit="atm")=0.5;/*pressure at exit*/
Real Pe_Aeby_P0e_Aestar;
Real Me;/*Mach number at exit*/
Real P0e_Pe;/*ratio of total pressure to static pressure at exit*/
Real P02_P01;/*ratio of total pressure behind and ahead of normal shock*/
Real A_by_At;/*shock position*/
equation
Ae_A1star=Ae_At;
Pe_Aeby_P0e_Aestar=(Pe/P01)*Ae_A1star;
Me^2=-(1/(gama-1))+sqrt((1/(gama-1)^2)+(2/(gama-1))*((2/(gama+1))^((gama+1)/(gama-1)))*(1/Pe_Aeby_P0e_Aestar^2));
P0e_Pe=1.094;
P02_P01=P0e_Pe*(Pe/P01);
A_by_At=2.36;
end Ex5_7;
