//=========================================================================
//Chapter-01, Basics of heat transfer
//Page No.: 8, Exercise - 1.1
//Title: Dimensions of units
//=========================================================================

model Ex1_1
//Variable section
//=========================================================================
Real q(unit= "W/m2") "Rate of heat loss in W/m2";
Real Q(unit = "Btu") "Heat loss to the environment over the specified surface area of the house wall in 24 hours";
Real Q_1(unit = "kWh") "Heat loss to the environment over the specified surface area of the house wall in 24 hours in SI units";

//=========================================================================
//Parameter Section 
parameter Real q1(unit = "Btu/hr.ft2") = 3.4 "Heat loss through the wall per square foot";
parameter Real t(unit = "hr") = 24 "Time";
parameter Real A(unit = "ft2") = 100 "Surface area";

//=========================================================================
//Equation Section
equation
q = (q1*0.2931)/0.0929;
//0.2931 is multiplied to convert Btu/hr to W/s
//0.0929 is divided to convert ft2 to m2
Q = q1*A*t;
Q_1 = Q*0.2931e-3;

end Ex1_1;